﻿"use strict";

// Exported variables.
var initializeAutoAdvance = null;
var AUTO_ADVANCE_DELAY = 300;

var autocomplete = 'autocomplete',
    choicegrid = 'choicegrid',
    imageselector = 'imageselector',
    imagechoicegrid = 'imagechoicegrid',
    imageareaselector = 'imageareaselector',
    netpromoter = 'netpromoter',
    starratinggrid = 'starratinggrid',
    checkbox = 'checkbox',
    radiobutton = 'radiobutton',
    dropdownlist = 'dropdownlist',
    respondenttimezone = 'respondenttimezone',
    respondentlanguage = 'respondentlanguage',
    description = "description";

var autoAdvanceCompatibleTypes = [
    autocomplete,
    choicegrid,
    imageselector,
    imagechoicegrid,
    imageareaselector,
    netpromoter,
    starratinggrid,
    checkbox,
    radiobutton,
    dropdownlist,
    respondenttimezone,
    respondentlanguage
];

var autoAdvanceExcludedTypes = [
    description
];

(function () {

    function $getQuestionDivs() {
        return $("div[id^=Q_]");
    }

    function getQuestionId($question) {
        return $question[0].id.slice(2);
    }

    function getVariablesForQuestion($question) {
        var variables = ($question.data('variables') || $question.closest('.questionBackground').data('variables')).split(',');
        return excludeOpenEndVariables($question, variables);
    }

    function excludeOpenEndVariables($question, variables) {
        var result = variables || [];

        if (variables.length > 1) {
            var openEndVariables = [];

            $("textarea[name*='_openEnd']", $question).each(function () {
                openEndVariables.push($(this).attr("name"));
            });

            result = _.filter(variables, function (item) {
                return !_.contains(openEndVariables, item + "_" + getCurrentMatrix() + "_openEnd");
            });
        }

        return result;
    }

    function getQuestionType($question) {
        return $question.find('.questionContainer').data('questiontype')
            || $question.data('questiontype');
    }

    var maxAnswers = 0;
    var questionType = ""; 

    function isAutoAdvanceCompatible($question) {
        questionType = getQuestionType($question);
        var isCompatible = _.contains(autoAdvanceCompatibleTypes, questionType) && getVariablesForQuestion($question).length === 1;

        if (isCompatible) {
            var $container = getQuestionContainer($question, questionType);

            if ($container)
            {
                maxAnswers = getMaxAnswers($container);

                if (questionType === checkbox || questionType === imageselector || questionType === imageareaselector || questionType === imagechoicegrid)
                {
                    isCompatible = $container.find('input[type=checkbox]').length === 1 || maxAnswers == 1;           
                }
                else if (questionType === choicegrid)
                {
                    isCompatible = $container.find('input[type=checkbox]').length === 0 || maxAnswers == 1;    
                }
            }
        }

        return isCompatible;
    }

    function getQuestionContainer($question, questionType)
    {
        var $container = null;

        if (questionType === checkbox || questionType === imageselector)
        {
            $container = $question.find('.choiceList');

            // for mobile
            if (isMobile || $container.length === 0)
                $container = $question.find('fieldset[data-role="controlgroup"]');
        }
        else if (questionType === choicegrid || questionType === imagechoicegrid)
        {
            $container = $question.find('.grid');

            // for mobile
            if (isMobile || $container.length === 0)
                $container = $question.find('.questionContainer.mobile');
        }
        else if (questionType === imageareaselector)
        {
            $container = $question.find('.imageMap');
        }

        return $container;
    }

    function getMaxAnswers($element) {
        var result = 0;

        if ($element.length > 0)
            result = parseInt($element.data("maxanswers"), 10);

        return isNaN(result) ? 0: result;
    }

    function getCurrentMatrix() {
        return $('#Matrix').val();
    }

    function navigateNext() {
        setTimeout(function () {
            var nextButton = $('.nextButton');
            if (nextButton.is(":enabled")) {
                nextButton.trigger("click");
            }
        }, AUTO_ADVANCE_DELAY);
    }

    function advanceIfValideValue() {
        var $questionContainer = $(this).closest(".questionContainer");

        // Do not advance if the question has become invisible.
        if (!$questionContainer.is(':visible'))
            return;

        // check input has open end variable
        if (hasOpenEnd($(this)))
            return;

        // check max value for compatible types as checkbox, imageselector and grids
        if (questionType === imagechoicegrid && !isValidMaxAnswerValue($questionContainer, $(this)))
            return;

        // check if existing option is selected
        if (!isSelectedOptionExists($questionContainer, $(this).val()))
            return;

        // If the input is a checkbox or radio button, advance if it is checked.
        if ($(this).is('[type=radio],[type=checkbox]'))
        {
            if ($(this).is(':checked'))
                navigateNext();
        }
        else {
            // Else, check if it's value is not empty.
            var val = $(this).val();

            if (val != null && val.length > 0)
                navigateNext();
        }
    }

    function isSelectedOptionExists($questionContainer, inputValue) {
        var result = true;

        if (getQuestionType($questionContainer) === autocomplete) {
            var options = [];

            if (isMobile || $questionContainer.hasClass("mobile"))
                options = $.map($questionContainer.find(".ui-listview .autocomplete-item"), function (elem) { return $(elem).data("value"); });
            else
                options = $.map($(".choiceList select>option"), function (e) { return e.value; });

            result = _.some(options, function (value) { return inputValue == value; });
        }

        return result;
    }

    function hasOpenEnd(input) {
        if ($(input).is("select"))
            input = $(input).children(":selected");

        return $(input).data("has-open-end") === true;
    }

    function isValidMaxAnswerValue($questionContainer, input) {
        var result = true;

        if (maxAnswers == 1) {
            var checkboxes = $($questionContainer).find(":checkbox[name='" + $(input).attr("name") + "']");

            if (checkboxes) {
                var checked = checkboxes.filter(":checked").length;
                var isMobileVersion = isMobile || $($questionContainer).hasClass("mobile");

                if ((!isMobileVersion && checked > maxAnswers) || (isMobileVersion && hasOpenEnd(input)))
                    result = false;
            }
        }

        return result;
    }

    var $questionInput = null;
    var isMobile = false;

    initializeAutoAdvance = function () {
        isMobile = $("html").hasClass("ui-mobile");

        // check if there is more then 1 question on page
        var questionDivs = $getQuestionDivs();

        // exclude questions types that do not require an answer
        questionDivs = _.filter(questionDivs, function (questionDiv) {
            return !_.contains(autoAdvanceExcludedTypes, getQuestionType($(questionDiv)))
        })

        if (questionDivs.length > 1)
            return;

        // Get the displayed question
        var $question = $(questionDivs).first();

        if (!isAutoAdvanceCompatible($question))
            return;

        // Get the variables of the last question.
        var questionVariables = getVariablesForQuestion($question);
        var variable = questionVariables[0];
        var matrix = getCurrentMatrix();

        $questionInput = $(":input[name=" + variable + "_" + matrix + "]");
        $questionInput.on("change", advanceIfValideValue);
    }

    $(document).ready(initializeAutoAdvance);
})();